<?php

namespace BalletMecanique\PianolaLaravel\Models;

use DB;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PianolaFormLocalisation extends Model
{
    protected $hidden = ['created_at', 'updated_at', 'id', 'pianola_form_element_id'];

    public function pianola_form_element(): BelongsTo
    {
        return $this->belongsTo(PianolaFormElement::class);
    }

    protected function values(): Attribute
    {
        return Attribute::make(
            get: function ($value) {
                if($this->values_label_column) {
                    return DB::table($this->pianola_form_element->values_table)
                        ->get()
                        ->map(function ($item) {
                            return [
                                'label' => $item->{$this->values_label_column},
                                'value' => $item->{$this->values_value_column},
                                'sort_order' => $item->sort_order ?? $item->{$this->values_label_column},
                            ];
                        })
                        ->sortBy('sort_order')
                        ->values()
                        ->toJson();
                }

                return $value;
            },
        );
    }
}
