<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\QueryBuilder;
use BalletMecanique\PianolaLaravel\Services\RightsChecker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class GlobalSearchController
{
    public function index(Request $request)
    {
        $configModules = collect($this->appConfigArray()['modules']);

        $globals_array = $configModules->map(function ($module) {
            return [
                'module_name' => $module['basicConfig']['name'] ?? null,
                'path' => $module['basicConfig']['path'] ?? null,
                'endpoint' => $module['basicConfig']['apiEndpoint'] ?? null,
                'description_column' => $module['recordTitleConfig'] ? $module['recordTitleConfig']['fieldTitle'] : null ,
                'icon' => $module['basicConfig']['icon'] ?? null,
            ];
        });


        // $globals_array = [
        //     [
        //         'endpoint' => 'assets',
        //         'path' => 'filme',
        //         'icon' => 'mdi-film',
        //         'description_column' => 'original_title',
        //         'module_name' => 'Film',
        //     ],
        //     [
        //         'endpoint' => 'events',
        //         'path' => 'programm-pakete',
        //         'icon' => 'mdi-filmstrip-box-multiple',
        //         'description_column' => 'name_de',
        //         'module_name' => 'Programmpaket',
        //     ],
        //     [
        //         'endpoint' => 'focuses',
        //         'path' => 'fokus-pakete',
        //         'icon' => 'mdi-camera-iris',
        //         'description_column' => 'name_de',
        //         'module_name' => 'Fokus-Paket',
        //     ],
        //     [
        //         'endpoint' => 'projects',
        //         'path' => 'projekte',
        //         'icon' => 'mdi-theater',
        //         'description_column' => 'name',
        //         'module_name' => 'Projekt',
        //     ],
        //     [
        //         'endpoint' => 'companies',
        //         'path' => 'firmen',
        //         'icon' => 'mdi-office-building',
        //         'description_column' => 'name',
        //         'module_name' => 'Firma',
        //     ],
        //     [
        //         'endpoint' => 'people',
        //         'path' => 'personen',
        //         'icon' => 'mdi-account',
        //         'description_column' => 'full_name',
        //         'module_name' => 'Person'
        //     ]
        // ];
        $array = [];

        foreach ($globals_array as $module) {
            if (! $this->filterColumnsAreDefined($module['endpoint'])) {
                continue;
            }
            if ($this->checkRights($module['endpoint']) == 'none') {
                continue;
            }
            $modelName = 'App\\Models\\'.Str::singular(Str::studly($module['endpoint']));
            $model = new $modelName();
            $records = new QueryBuilder($model, $request);
            $records = $records->get();
            foreach ($records as $record) {
                $subarray = [];
                $subarray['id'] = $record['id'];
                $subarray['name'] = $record[$module['description_column']];
                $subarray['path'] = $module['path'];
                $subarray['color'] = $module['color'] ?? 'rgb(225, 119, 149)';
                $subarray['icon'] = $module['icon'] ?? null;
                $subarray['endpoint'] = $module['module_name'];
                $array[] = $subarray;
            }
        }

        $array = collect($array)->sortBy('name')->values()->all();

        return $array;
    }

    protected function filterColumnsAreDefined($endpoint)
    {
        return collect($this->schemaConfigArray())->where('name', $endpoint)->first()['app_record_filter_columns'] ?? null;
    }

    protected function checkRights($endpoint)
    {
        $checker = new RightsChecker();

        return $checker->checkEndpointRights($endpoint);
    }

    protected function appConfigArray()
    {
        return json_decode(
            File::get(config_path('/pianola/app.json')),
            true
        );
    }

    protected function schemaConfigArray()
    {
        return json_decode(
            File::get(config_path('/pianola/schema.json')),
            true
        );
    }
}
