<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_cms_table_content_elements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_cms_content_element_id')->nullable();
            $table->text('text_column_1_de')->nullable();
            $table->text('text_column_1_en')->nullable();
            $table->text('text_column_2_de')->nullable();
            $table->text('text_column_2_en')->nullable();
            $table->text('text_column_3_de')->nullable();
            $table->text('text_column_3_en')->nullable();
            $table->string('show_if')->nullable();
            $table->boolean('is_highlighted')->nullable();
            $table->integer('sort_order')->nullable();
            $table->timestamps();

            $table->foreign('pianola_cms_content_element_id', 'constrain_table_content_elements')
                ->references('id')
                ->on('pianola_cms_content_elements')
                ->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_cms_table_content_elements');
    }
};
