<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/vuetify@2.3.23/dist/vuetify.min.css" rel="stylesheet">
    <link rel=stylesheet href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-size: 8px !important;
        }

        html, body, #app {
            width: 272mm;
        }

        /* Print-specific styles */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }

            .page-break {
                page-break-before: always;
            }

            .no-page-break {
                page-break-inside: avoid;
            }
        }

        .header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            margin-left: 10px;
        }

        .logo {
            width: 25px;
        }

        .titleText {
            font-size: 16px !important;
            font-weight: 500;
            margin-left: 12px;
        }

        .frame {
            width: 100%;
        }

        .page-break {
            page-break-before: always;
        }

        /* Calendar styles from original printouts.calendar - exact match */
        .pianola-day-calendar, .pianola-week-calendar {
            border-bottom: 1px solid #e0e0e0;
            border-right: 1px solid #e0e0e0;
            margin: 5px 5px -6px;
        }

        .v-calendar-daily__day {
            margin-right: -2px;
            border-right: 0;
            border-bottom: 0 !important;
        }

        .v-calendar-daily__intervals-head:after {
            display: none;
        }

        .v-calendar-daily__intervals-head {
            border-bottom: 1px solid #e0e0e0;
        }

        .v-calendar-daily__interval-text {
            font-size: 8px;
        }

        .v-calendar-daily_head-day {
            margin-right: -1px !important;
            border-right: 0 !important;
        }

        .v-calendar-daily_head-day-label .v-btn {
            height: 30px;
            width: 30px;
        }

        .v-calendar-daily_head-weekday, .v-calendar-daily_head-day-label {
            color: black !important;
        }

        .pianola-day-calendar .v-calendar-daily_head-weekday,
        .pianola-day-calendar .v-calendar-daily_head-day-label {
            display: none;
        }

        .pianola-day-calendar .v-calendar-category__column-header {
            min-height: 30px;
            padding-top: 4px;
        }

        .theme--light.v-calendar-events .v-event-timed {
            border: 0.25px solid white !important;
            padding: 2px !important;
        }

        .v-event-timed-container {
            margin-right: 0 !important;
        }

        .v-calendar-daily__scroll-area, .v-calendar-daily__pane {
            overflow: hidden !important;
        }
    </style>
    <title>{{ $listName }} - {{ $type === 'daily' ? __('pianola-laravel::shared-data.all_days') : __('pianola-laravel::shared-data.all_weeks') }}</title>
</head>
<body>
<div id="app">
    <v-app>
        @foreach($allPeriodsData as $index => $periodData)
            @if($index > 0)
                <div class="page-break"></div>
            @endif
            <div class="header">
                @if($logoPath)
                    <img class="logo" src="{{ $logoPath }}" alt="logo"/>
                @endif
                <div class="titleText">{{ isset($listName) ? $listName . ' - ' : '' }}{{ $periodData['title'] }}</div>
            </div>
            <div class="frame">
                    @if($periodData['type'] === 'daily')
                        <v-calendar
                            ref="calendar{{ $index }}"
                            :value="periods[{{ $index }}].date"
                            :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                            type="category"
                            locale="de-CH"
                            interval-count="16"
                            interval-height="39"
                            :categories="periods[{{ $index }}].locations"
                            :category-hide-dynamic="true"
                            :category-show-all="true"
                            first-time="08:00"
                            :events="periods[{{ $index }}].parsedEvents"
                            event-overlap-mode="column"
                            light
                            class="pianola-day-calendar"
                            :event-overlap-threshold="10"
                            :event-color="getEventColor"
                            :event-text-color="getEventTextColor"
                        >
                            <template v-slot:category="{category}">
                                <div v-html="formattedCategory(category)" style="text-align: center;"></div>
                            </template>
                            <template v-slot:event="{ event }">
                                <div style="margin: 2px; overflow: hidden;">
                                    <div style="margin-top: -2px; margin-bottom: 0;">
                                        <strong class="font-medium" v-html="event.name"
                                                style="font-size: 8px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                                    </div>
                                    <div
                                        style="white-space: pre-wrap; width: 100%; font-size: 8px;"
                                        v-html="stripFontSizes(event.moreInformation)"
                                    ></div>
                                </div>
                            </template>
                        </v-calendar>
                    @else
                        <v-calendar
                            ref="calendar{{ $index }}"
                            :value="periods[{{ $index }}].date"
                            :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                            type="week"
                            locale="de-CH"
                            interval-count="16"
                            interval-height="38"
                            first-time="08:00"
                            :events="periods[{{ $index }}].parsedEvents"
                            event-overlap-mode="column"
                            light
                            class="pianola-week-calendar"
                            :event-overlap-threshold="10"
                            :event-color="getEventColor"
                            :event-text-color="getEventTextColor"
                        >
                            <template v-slot:day-label-header="{date}">
                                @{{formatDate(date)}}
                            </template>
                            <template v-slot:event="{ event }">
                                <div style="margin: 2px; overflow: hidden;">
                                    <div style="margin-top: -2px; margin-bottom: 0;">
                                        <strong class="font-medium" v-html="event.name"
                                                style="font-size: 8px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                                    </div>
                                    <div
                                        style="white-space: pre-wrap; width: 100%; font-size: 8px;"
                                        v-html="stripFontSizes(event.moreInformation)"
                                    ></div>
                                </div>
                            </template>
                        </v-calendar>
                    @endif
            </div>
        @endforeach
    </v-app>
</div>

<script src="https://cdn.jsdelivr.net/npm/vue@2.x/dist/vue.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vuetify@2.3.23/dist/vuetify.js"></script>
<script>
    new Vue({
        el: '#app',
        vuetify: new Vuetify(),
        data() {
            return {
                periods: {!! json_encode($allPeriodsData) !!},
                type: {!! json_encode($type) !!},
            }
        },
        computed: {
            // Process events for each period
        },
        mounted() {
            // Process events for each period
            this.periods.forEach((period, index) => {
                this.$set(period, 'parsedEvents', this.parseEvents(period.events, period.type));
            });
        },
        methods: {
            parseEvents(events, type) {
                return events.map((item) => {
                    return {
                        id: item.calendar_id,
                        locked: item.calendar_locked || false,
                        name: item.calendar_name,
                        start: item.calendar_timestamp_start,
                        end: item.calendar_timestamp_end,
                        moreInformation: type === 'daily' ? item.calendar_more_information : item.calendar_location,
                        category: item.calendar_location,
                        timed: true,
                        color: item.calendar_color || "grey",
                    };
                });
            },
            formattedCategory(category) {
                if (category.includes('<br/>')) {
                    const parts = category.split('<br/>');
                    return `<div style="font-size: 8px;">${parts[0]}</div><div style="font-size: 6px; margin-bottom: 4px;">${parts[1]}</div>`;
                } else {
                    return `<div style="font-size: 8px; margin-bottom: 4px;">${category}</div>`;
                }
            },
            formatDate(string) {
                const date = new Date(string);
                return `${date.getDate()}.${date.getMonth() + 1}.${date.getFullYear()}`;
            },
            getEventColor(event) {
                return event.color;
            },
            getEventTextColor(event) {
                if (this.getColorBrightness(event.color) === "dark") {
                    return "#fff";
                } else {
                    return "#222";
                }
            },
            getColorBrightness(color) {
                color = color.replace("#", "");
                const r = parseInt(color.substr(0, 2), 16);
                const g = parseInt(color.substr(2, 2), 16);
                const b = parseInt(color.substr(4, 2), 16);
                const luminance = (0.2126 * r + 0.7152 * g + 0.0722 * b) / 255;
                return luminance < 0.5 ? "dark" : "light";
            },
            stripFontSizes(content) {
                if (!content) return content;
                // Remove font-size styles from inline style attributes
                return content.replace(/font-size\s*:\s*[^;]+;?/gi, '');
            },
        }
    })

    // Auto-print functionality - improved version
    let printExecuted = false;

    // Wait for Vue to fully render all calendars, then trigger print
    setTimeout(function () {
        if (!printExecuted) {
            printExecuted = true;
            window.print();
        }
    }, 1000); // Longer delay to ensure all calendars are fully rendered

    // Handle print dialog completion (when user prints or cancels)
    window.addEventListener('afterprint', function() {
        setTimeout(function () {
            window.close();
        }, 100);
    });

    // Handle when user cancels print dialog or returns focus to window
    let focusCount = 0;
    window.addEventListener('focus', function() {
        focusCount++;
        // Only close after print has been triggered and focus returns
        if (printExecuted && focusCount > 1) {
            setTimeout(function () {
                window.close();
            }, 100);
        }
    });

    // Fallback: close window after reasonable time if still open
    setTimeout(function() {
        if (printExecuted) {
            window.close();
        }
    }, 30000); // Close after 30 seconds
</script>
</body>
</html>
