<?php

namespace BalletMecanique\PianolaLaravel\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class GenerateFileUploadBoilerplateCommand extends Command
{
    public $signature = 'pianola:generate-file-upload-boilerplate {--vapor}';

    public $description = 'Creates the boilerplate files for the file upload process';

    public function handle(): int
    {
        $this->call('vendor:publish', [
            '--tag' => 'file-models',
        ]);
        $this->call('vendor:publish', [
            '--tag' => 'file-migrations',
        ]);
        $this->writeToEndOfPianolaRoutesFile('//file upload');
        $this->addControllerRoute('post', 'file-upload', 'FileUploadController', 'store');
        if ($this->option('vapor')) {
            $this->call('vendor:publish', [
                '--tag' => 'file-upload-controllers-vapor',
            ]);
            $this->addControllerRoute('post', 'vapor/signed-storage-url', 'SignedStorageUrlController', 'store');
        } else {
            $this->call('vendor:publish', [
                '--tag' => 'file-upload-controller',
            ]);
        }

        return self::SUCCESS;
    }

    protected function addControllerRoute($requestMethod, $route, $controller, $method)
    {
        $fullRoute = "Route::{$requestMethod}('{$route}', [App\Http\Controllers\\$controller::class, '{$method}']);";
        $this->writeToEndOfPianolaRoutesFile($fullRoute);
    }

    protected function writeToEndOfPianolaRoutesFile($content)
    {
        $routesFile = base_path('routes/pianola.php');
        $oldContent = File::get($routesFile);
        if (strpos($oldContent, $content) !== false) {
            return;
        }
        $newContent = $oldContent."\n".$content;
        File::put($routesFile, $newContent);
    }
}
