<?php

namespace BalletMecanique\PianolaLaravel\Commands;

use BalletMecanique\PianolaLaravel\Mail\AlertMail;
use BalletMecanique\PianolaLaravel\Models\PianolaAlert;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class SendAlertsCommand extends Command
{
    public $signature = 'pianola:send-alerts';

    public $description = 'Sends today\'s alerts to all users.';

    public function handle(): int
    {
        $alerts = PianolaAlert::whereDate('date', '=', date('Y-m-d'))->with('user')->get();

        if ($alerts->count() > 0) {
            foreach ($alerts as $alert) {
                $mail = Mail::to($alert->user->email);
                if (env('ALERT_BCC')) {
                    $mail->bcc(env('ALERT_BCC'));
                }
                $mail->send(new AlertMail($alert));
            }
        }

        return self::SUCCESS;
    }
}
