<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $sharedDataList->name }} - Shared Data</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if (config('pianola-laravel.has_font_file'))
        <link href="{{ asset('fonts/font.css') }}" rel="stylesheet">
    @else
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900">
    @endif
    <script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
    <script src="https://unpkg.com/xlsx/dist/xlsx.full.min.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: white;
        }

        .navbar {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            padding: 1rem 2rem 1rem 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .navbar-content {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }

        .navbar-title {
            font-size: 1.5rem;
            font-weight: bold;
        }

        .navbar-subtitle {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .navbar-logo {
            height: 40px;
            width: auto;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .user-dropdown {
            position: relative;
            display: inline-block;
            border: 1px solid #999;
            border-radius: 4px;
            padding: 0.375rem 0.5rem;
        }

        .user-name {
            font-weight: 400;
            color: #ddd;
            font-size: 0.85rem;
            cursor: pointer;
            transition: background-color 0.2s;
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        .user-dropdown:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .user-icon {
            width: 16px;
            height: 16px;
            fill: #ddd;
        }

        .dropdown-arrow {
            font-size: 0.6rem;
            margin-left: 0.15rem;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            top: calc(100% + 0.5rem);
            background-color: white;
            border: 1px solid white;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            min-width: 120px;
            z-index: 1000;
        }

        .dropdown-content.show {
            display: block;
        }

        .dropdown-item {
            color: #333;
            padding: 0.75rem 1rem;
            text-decoration: none;
            display: block;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .dropdown-item:hover {
            background-color: #f8f9fa;
        }



        .back-btn {
            color: white;
            text-decoration: none;
            font-size: 0.9rem;
            transition: color 0.2s;
        }

        .back-btn:hover {
            color: #ccc;
            text-decoration: underline;
        }

        .main-content {
            padding: 0;
            width: 100%;
            height: calc(100vh - 86px); /* Full height minus navbar */
            overflow: auto;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #ddd;
            font-size: 0.9rem;
        }

        .data-table th,
        .data-table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        .data-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #333;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .data-table tr:hover {
            background-color: #f8f9fa;
        }

        .no-data {
            text-align: center;
            color: #666;
            font-style: italic;
            padding: 3rem;
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 1rem;
            background-color: #f8f9fa;
            border-bottom: 1px solid #ddd;
        }

        .search-container {
            flex: 1;
            max-width: 400px;
        }

        .search-input {
            width: 100%;
            padding: 0.5rem 1rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 0.9rem;
        }

        .search-input:focus {
            outline: none;
            border-color: #007cba;
            box-shadow: 0 0 0 2px rgba(0, 124, 186, 0.1);
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
            margin-left: 1rem;
        }

        .btn {
            padding: 0.5rem 1rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: white;
            color: #333;
            text-decoration: none;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.2s;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn:hover {
            background-color: #f8f9fa;
            border-color: #007cba;
            color: #007cba;
        }

        .btn-icon {
            width: 16px;
            height: 16px;
            fill: currentColor;
        }


    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            @if($appConfig['logoPath'])
                <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="navbar-logo">
            @endif
            <div class="navbar-content">
                <div class="navbar-title">{{ $sharedDataList->name }}</div>
                @if($recordCount > 0)
                    <div class="navbar-subtitle">
                        {{ trans_choice('pianola-laravel::shared-data.showing_records', $recordCount, ['count' => number_format($recordCount)]) }} {{ __('pianola-laravel::shared-data.from_table', ['table' => $sharedDataList->base_table]) }}
                    </div>
                @endif
            </div>
        </div>
        <div class="navbar-user">
            <a href="{{ route('shared-data.index') }}" class="back-btn">{{ __('pianola-laravel::shared-data.back_to_lists') }}</a>
            <div class="user-dropdown" onclick="toggleDropdown()">
                <span class="user-name">
                    <svg class="user-icon" viewBox="0 0 24 24">
                        <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                    </svg>
                    {{ $user->name }}
                    <span class="dropdown-arrow">▼</span>
                </span>
                <div class="dropdown-content" id="userDropdown">
                    <a class="dropdown-item" onclick="logout()">{{ __('pianola-laravel::shared-data.logout') }}</a>
                </div>
            </div>
        </div>
    </nav>

    <main class="main-content" id="app">
        @if($recordCount > 0)
            <div class="table-header">
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="{{ __('pianola-laravel::shared-data.search_placeholder') }}" v-model="searchTerm">
                </div>
                <div class="action-buttons">
                    <button class="btn" @click="exportToExcel">
                        <svg class="btn-icon" viewBox="0 0 24 24">
                            <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                        </svg>
                        {{ __('pianola-laravel::shared-data.export_excel') }}
                    </button>
                    @if($hasCalendar)
                        <button class="btn" onclick="window.location.href='{{ route('shared-data.show', $sharedDataList->id) }}?display=calendar'">
                            <svg class="btn-icon" viewBox="0 0 24 24">
                                <path d="M19,3H18V1H16V3H8V1H6V3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3M19,19H5V8H19V19M5,6V5H19V6H5Z"/>
                            </svg>
                            {{ __('pianola-laravel::shared-data.calendar_view') }}
                        </button>
                    @endif
                    <button class="btn" onclick="window.location.href='{{ route('shared-data.api-management', $sharedDataList->id) }}'">
                        <svg class="btn-icon" viewBox="0 0 24 24">
                            <path d="M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M12,4A8,8 0 0,1 20,12A8,8 0 0,1 12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4M12,6A6,6 0 0,0 6,12A6,6 0 0,0 12,18A6,6 0 0,0 18,12A6,6 0 0,0 12,6M12,8A4,4 0 0,1 16,12A4,4 0 0,1 12,16A4,4 0 0,1 8,12A4,4 0 0,1 12,8Z"/>
                        </svg>
                        {{ __('pianola-laravel::shared-data.api') }}
                    </button>
                </div>
            </div>

            <table class="data-table">
                        <thead>
                            <tr>
                                <th v-for="column in columns" :key="column.value">
                                    @{{ column.text || column.value || 'Unknown' }}
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="record in filteredData" :key="record.id || Math.random()">
                                <td v-for="column in columns" :key="column.value">
                                    @{{ getFieldValue(record, column.value) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <div v-if="filteredData.length === 0 && searchTerm" class="no-data">
                        {{ __('pianola-laravel::shared-data.no_search_results') }}
                    </div>
        @else
            <div class="no-data">
                {{ __('pianola-laravel::shared-data.no_data') }}
            </div>
        @endif
    </main>

    <script>
        const { createApp } = Vue;

        createApp({
            data() {
                return {
                    searchTerm: '',
                    data: @json($filteredData->toArray()),
                    columns: @json($columns)
                }
            },
            computed: {
                filteredData() {
                    if (!this.searchTerm) {
                        return this.data;
                    }

                    const searchLower = this.searchTerm.toLowerCase();
                    return this.data.filter(record => {
                        // Search through all column values
                        return this.columns.some(column => {
                            const value = this.getFieldValue(record, column.value);
                            return value.toString().toLowerCase().includes(searchLower);
                        });
                    });
                }
            },
            methods: {
                getFieldValue(record, field) {
                    if (!field) return 'N/A';

                    // Handle nested field access (e.g., 'user.name')
                    let value = field.split('.').reduce((obj, key) => {
                        return obj && obj[key] !== undefined ? obj[key] : undefined;
                    }, record);

                    // If field not found, try direct access
                    if (value === undefined) {
                        value = record[field];
                    }

                    // Handle different data types
                    if (Array.isArray(value) || (typeof value === 'object' && value !== null)) {
                        return JSON.stringify(value);
                    } else if (typeof value === 'boolean') {
                        return value ? 'Yes' : 'No';
                    } else if (value === null || value === undefined) {
                        return '';
                    }

                    return value;
                },

                exportToExcel() {
                    // Create workbook and worksheet
                    const wb = XLSX.utils.book_new();

                    // Prepare data for export
                    const exportData = [];

                    // Add headers
                    const headers = this.columns.map(col => col.text || col.value || 'Unknown');
                    exportData.push(headers);

                    // Add data rows (use filtered data to respect search)
                    this.filteredData.forEach(record => {
                        const row = this.columns.map(column => {
                            const value = this.getFieldValue(record, column.value);
                            // Clean up the value for Excel
                            if (typeof value === 'string' && value.startsWith('"') && value.endsWith('"')) {
                                return value.slice(1, -1); // Remove quotes from JSON strings
                            }
                            return value;
                        });
                        exportData.push(row);
                    });

                    // Create worksheet from data
                    const ws = XLSX.utils.aoa_to_sheet(exportData);

                    // Auto-size columns
                    const colWidths = [];
                    exportData.forEach(row => {
                        row.forEach((cell, i) => {
                            const cellLength = cell ? cell.toString().length : 0;
                            colWidths[i] = Math.max(colWidths[i] || 0, cellLength + 2);
                        });
                    });
                    ws['!cols'] = colWidths.map(w => ({ width: Math.min(w, 50) })); // Max width 50

                    // Add worksheet to workbook
                    const sheetName = '{{ $sharedDataList->name }}';
                    XLSX.utils.book_append_sheet(wb, ws, sheetName);

                    // Generate filename
                    const timestamp = new Date().toISOString().slice(0, 19).replace(/[:-]/g, '_');
                    const cleanSheetName = sheetName.replace(/\s+/g, '_');
                    const filename = `${cleanSheetName}_${timestamp}.xlsx`;

                    // Save file
                    XLSX.writeFile(wb, filename);
                }
            }
        }).mount('#app');

        // Dropdown functionality (outside Vue app)
        function toggleDropdown() {
            const dropdown = document.getElementById('userDropdown');
            dropdown.classList.toggle('show');
        }

        // Close dropdown when clicking outside
        window.onclick = function(event) {
            if (!event.target.matches('.user-name')) {
                const dropdown = document.getElementById('userDropdown');
                if (dropdown.classList.contains('show')) {
                    dropdown.classList.remove('show');
                }
            }
        }

        async function logout() {
            try {
                const response = await fetch('{{ route("shared-data.logout") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                });

                if (response.ok) {
                    window.location.href = '{{ route("shared-data.login") }}';
                } else {
                    alert('Logout failed. Please try again.');
                }
            } catch (error) {
                alert('An error occurred during logout. Please try again.');
            }
        }
    </script>
</body>
</html>
