<?php

namespace BalletMecanique\PianolaLaravel\Http\Middleware;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class RemoveNestedArraysMiddleware
{
    public function handle(Request $request, Closure $next): JsonResponse|Response
    {
        $response = $next($request);

        if ($response instanceof JsonResponse) {
            $requestIncludesExcelParameter = $request->query('excel');
            if ($response->exception || $requestIncludesExcelParameter) {
                return $response;
            }
            $data = $response->getData(true); // Convert JsonResponse to array
            $data = $this->excludeNestedArrays($data); // Remove nested arrays
            $response = response()->json($data); // Convert array back to JsonResponse
        }

        return $response;
    }

    protected function excludeNestedArrays(array $array, $isTopLevel = true)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if ($isTopLevel) {
                    // Process the top-level array and recursively call the function
                    $array[$key] = array_map(function ($item) {
                        if (is_array($item)) {
                            return $this->excludeNestedArrays($item, false);
                        }

                        return $item; // Return the item if it's not an array
                    }, $value);
                } else {
                    // Check if the value is an array of arrays
                    $isArrayofArrays = count(array_filter($value, 'is_array')) === count($value);
                    if ($isArrayofArrays) {
                        // Remove the key if it's an array of arrays
                        unset($array[$key]);
                    } else {
                        // Retain associative arrays with keys
                        $array[$key] = $this->excludeNestedArrays($value, false);
                    }
                }
            }
        }

        return $array;
    }
}
