<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\FormController;
use BalletMecanique\PianolaLaravel\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

Route::macro('pianola', function () {
    $formsSubdomain = config('app.forms_subdomain') ?? 'forms';
    Route::domain($formsSubdomain . '.' . config('app.domain'))->group(function () {
        Route::get('/api/form-styling', [FormController::class, 'getStyling']);
        Route::get('/api/form-basics/{slug}', [FormController::class, 'getFormBasics']);
        Route::get('/api/form-elements/{slug}', [FormController::class, 'getFormElements']);
        Route::get('/api/form-data/{submissionId}', [FormController::class, 'getFormData']);
        Route::get('/api/form-data', fn() => null);
        Route::post('/api/form-submissions', [FormController::class, 'store']);
        Route::get('/{slug}/{id?}', [FormController::class, 'create']);
        Route::get('/', fn() => null);
    });

    Route::get('/', [HomeController::class, 'show']);
    Route::get('/login', [HomeController::class, 'show']);

    Route::get('/{any}', [HomeController::class, 'show'])->where('any', '.*');

});
