<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaQuery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QueryController
{
    public function index(Request $request)
    {
        $base_table = $request->input('base_table');

        return PianolaQuery::where('base_table', $base_table)->get();
    }

    public function store(Request $request)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;

        return PianolaQuery::create($input);
    }

    public function show($id)
    {
        $query = PianolaQuery::find($id);
        //some stored queries lack an id in the table grouping, this is a fix for that
        $queryArray = json_decode(urldecode(base64_decode($query->query)), true);
        $modifiedQuery = $this->addMissingTableGroupingIds($queryArray);
        $encodedQuery = base64_encode(json_encode($modifiedQuery));
        $query->query = $encodedQuery;

        return $query;
    }

    protected function addMissingTableGroupingIds($array)
    {
        // Iterate over each orQueries
        foreach ($array['orQueries'] as &$orQuery) {
            // Iterate over tableGroupings within orQuery
            foreach ($orQuery['tableGroupings'] as &$tableGrouping) {
                // Generate random alphanumeric id
                $randomId = $this->generateRandomId(5);
                // Assign the generated id to tableGrouping
                $tableGrouping['id'] = $randomId;
            }
        }

        return $array;
    }

    protected function generateRandomId($length)
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, strlen($characters) - 1)];
        }

        return $randomString;
    }

    public function update(Request $request, $id)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;
        $query = PianolaQuery::find($id);
        $query->update($input);

        return $query;
    }

    public function destroy($id)
    {
        $query = PianolaQuery::destroy($id);

        return 'ok';
    }
}
