<?php

namespace BalletMecanique\PianolaLaravel\Services;

use Illuminate\Support\Facades\File;

class RightsChecker
{
    public function checkEndpointRights($endpoint)
    {
        $user = auth()->user();
        $userModules = json_decode($user->modules, true);
        if ($userModules == []) {
            return 'write';
        }
        $configModules = collect(json_decode(
            File::get(config_path('/pianola/app.json')),
            true
        )['modules']);
        $thisModuleName = $configModules->pluck('basicConfig')->where('apiEndpoint', $endpoint)->first()['name'] ?? null;
        if (! $thisModuleName) {
            return 'write';
        }

        return $userModules[$thisModuleName] ?? (in_array($thisModuleName, $userModules) ? 'write' : 'none');
    }
}
