<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $sharedDataList->name }} - API Management</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if (config('pianola-laravel.has_font_file'))
        <link href="{{ asset('fonts/font.css') }}" rel="stylesheet">
    @else
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900">
    @endif
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: white;
        }

        .navbar {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            padding: 1rem 2rem 1rem 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .navbar-logo {
            height: 40px;
            width: auto;
        }

        .navbar-content {
            display: flex;
            flex-direction: column;
        }

        .navbar-title {
            font-size: 1.25rem;
            font-weight: bold;
        }

        .navbar-subtitle {
            font-size: 0.875rem;
            opacity: 0.9;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .back-btn {
            color: white;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 4px;
            transition: background-color 0.2s;
        }

        .back-btn:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .main-content {
            padding: 2rem;
            max-width: 1200px;
            margin: 0 auto;
        }

        .api-section {
            background: white;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 2rem;
            margin-bottom: 2rem;
        }

        .api-section h2 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #1f2937;
        }

        .api-section h3 {
            font-size: 1.25rem;
            margin-bottom: 0.75rem;
            color: #374151;
        }

        .api-key-container {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .api-key-display {
            font-family: 'Courier New', monospace;
            background: #f3f4f6;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 4px;
            flex: 1;
            word-break: break-all;
        }

        .copy-container {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .copy-field {
            font-family: 'Courier New', monospace;
            background: #f3f4f6;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 4px;
            flex: 1;
            word-break: break-all;
        }

        .copy-btn {
            background-color: #6b7280;
            color: white;
            border: none;
            padding: 0.75rem;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 44px;
            transition: background-color 0.2s;
        }

        .copy-btn:hover {
            background-color: #4b5563;
        }

        .copy-btn.copied {
            background-color: #10b981;
        }

        .copy-btn svg {
            width: 16px;
            height: 16px;
        }

        .btn {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.875rem;
            transition: opacity 0.2s;
        }

        .btn:hover {
            opacity: 0.9;
        }

        .btn-secondary {
            background-color: #6b7280;
        }

        .endpoint-url {
            font-family: 'Courier New', monospace;
            background: #f3f4f6;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 4px;
            margin-bottom: 1rem;
            word-break: break-all;
        }

        .json-preview {
            background: #1f2937;
            color: #f9fafb;
            padding: 1.5rem;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 0.875rem;
            line-height: 1.5;
            overflow-x: auto;
            max-height: 400px;
            overflow-y: auto;
            white-space: pre-wrap;
        }

        .json-preview .json-key {
            color: #60a5fa;
        }

        .json-preview .json-string {
            color: #34d399;
        }

        .json-preview .json-number {
            color: #fbbf24;
        }

        .json-preview .json-boolean {
            color: #f87171;
        }

        .json-preview .json-null {
            color: #9ca3af;
        }

        .alert {
            padding: 1rem;
            border-radius: 4px;
            margin-bottom: 1rem;
        }

        .alert-success {
            background-color: #d1fae5;
            border: 1px solid #a7f3d0;
            color: #065f46;
        }

        .usage-instructions {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .usage-instructions h3 {
            margin-bottom: 1rem;
            color: #1e293b;
        }

        .usage-instructions code {
            background: #e2e8f0;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }

        .usage-instructions pre {
            background: #1e293b;
            color: #f1f5f9;
            padding: 1rem;
            border-radius: 4px;
            overflow-x: auto;
            margin: 0.5rem 0;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            @if($appConfig['logoPath'])
                <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="navbar-logo">
            @endif
            <div class="navbar-content">
                <div class="navbar-title">{{ $sharedDataList->name }} - API Management</div>
                <div class="navbar-subtitle">
                    {{ __('pianola-laravel::shared-data.api_management_subtitle') }}
                </div>
            </div>
        </div>
        <div class="navbar-user">
            <a href="{{ route('shared-data.show', $sharedDataList->id) }}" class="back-btn">{{ __('pianola-laravel::shared-data.back_to_data') }}</a>
        </div>
    </nav>

    <main class="main-content">
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <div class="api-section">
            <h2>{{ __('pianola-laravel::shared-data.what_is_api') }}</h2>
            <p style="margin-bottom: 1rem; line-height: 1.6;">
                {{ __('pianola-laravel::shared-data.api_explanation') }}
            </p>
        </div>

        <div class="api-section">
            <h2>{{ __('pianola-laravel::shared-data.api_key_management') }}</h2>

            @if($user->hasApiKey())
                <div class="copy-container">
                    <div class="copy-field">{{ $user->api_key }}</div>
                    <button type="button" class="copy-btn" onclick="copyToClipboard('{{ $user->api_key }}', this)" title="{{ __('pianola-laravel::shared-data.copy_api_key') }}">
                        <svg viewBox="0 0 24 24" fill="currentColor">
                            <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
                        </svg>
                    </button>
                </div>
                <form method="POST" action="{{ route('shared-data.generate-api-key', $sharedDataList->id) }}" style="margin-bottom: 1rem;">
                    @csrf
                    <button type="submit" class="btn" onclick="return confirm('{{ __('pianola-laravel::shared-data.regenerate_api_key_confirm') }}')">
                        {{ __('pianola-laravel::shared-data.regenerate_api_key') }}
                    </button>
                </form>
            @else
                <p style="margin-bottom: 1rem;">{{ __('pianola-laravel::shared-data.no_api_key_message') }}</p>
                <form method="POST" action="{{ route('shared-data.generate-api-key', $sharedDataList->id) }}" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn">
                        {{ __('pianola-laravel::shared-data.generate_api_key') }}
                    </button>
                </form>
            @endif
        </div>

        @if($user->hasApiKey())
            <div class="api-section">
                <h2>{{ __('pianola-laravel::shared-data.api_endpoint') }}</h2>
                <div class="copy-container">
                    <div class="copy-field">{{ $apiEndpointUrl }}</div>
                    <button type="button" class="copy-btn" onclick="copyToClipboard('{{ $apiEndpointUrl }}', this)" title="{{ __('pianola-laravel::shared-data.copy_endpoint') }}">
                        <svg viewBox="0 0 24 24" fill="currentColor">
                            <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
                        </svg>
                    </button>
                </div>
            </div>

            <div class="usage-instructions">
                <h3>{{ __('pianola-laravel::shared-data.usage_instructions') }}</h3>
                <p>{{ __('pianola-laravel::shared-data.usage_instructions_text') }}</p>

                <h4 style="margin-top: 1rem; margin-bottom: 0.5rem;">{{ __('pianola-laravel::shared-data.using_header') }}:</h4>
                <pre>curl -H "X-API-Key: {{ $user->api_key }}" {{ $apiEndpointUrl }}</pre>

                <h4 style="margin-top: 1rem; margin-bottom: 0.5rem;">{{ __('pianola-laravel::shared-data.using_parameter') }}:</h4>
                <pre>curl "{{ $apiEndpointUrl }}?api_key={{ $user->api_key }}"</pre>
            </div>

            <div class="api-section">
                <h2>{{ __('pianola-laravel::shared-data.api_response_preview') }}</h2>
                <p style="margin-bottom: 1rem;">{{ __('pianola-laravel::shared-data.api_response_preview_text') }}</p>
                <div class="json-preview" id="json-preview"></div>
            </div>
        @endif
    </main>

    <script>
        // Function to copy text to clipboard
        function copyToClipboard(text, button) {
            navigator.clipboard.writeText(text).then(function() {
                // Show success feedback
                const originalContent = button.innerHTML;
                button.innerHTML = '<svg viewBox="0 0 24 24" fill="currentColor"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/></svg>';
                button.classList.add('copied');

                // Reset after 2 seconds
                setTimeout(function() {
                    button.innerHTML = originalContent;
                    button.classList.remove('copied');
                }, 2000);
            }).catch(function(err) {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = text;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);

                // Show success feedback
                const originalContent = button.innerHTML;
                button.innerHTML = '<svg viewBox="0 0 24 24" fill="currentColor"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/></svg>';
                button.classList.add('copied');

                setTimeout(function() {
                    button.innerHTML = originalContent;
                    button.classList.remove('copied');
                }, 2000);
            });
        }

        // Function to syntax highlight JSON
        function syntaxHighlight(json) {
            if (typeof json != "string") {
                json = JSON.stringify(json, undefined, 2);
            }
            json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
            return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
                var cls = 'json-number';
                if (/^"/.test(match)) {
                    if (/:$/.test(match)) {
                        cls = 'json-key';
                    } else {
                        cls = 'json-string';
                    }
                } else if (/true|false/.test(match)) {
                    cls = 'json-boolean';
                } else if (/null/.test(match)) {
                    cls = 'json-null';
                }
                return '<span class="' + cls + '">' + match + '</span>';
            });
        }

        // Apply syntax highlighting to the JSON preview
        @if($user->hasApiKey())
            document.addEventListener('DOMContentLoaded', function() {
                const jsonData = @json($sampleResponse);
                const highlighted = syntaxHighlight(jsonData);
                document.getElementById('json-preview').innerHTML = highlighted;
            });
        @endif
    </script>
</body>
</html>
