<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

class GlobalFilterController
{
    public function show(Request $request, $endpoint, $valueField, $labelField)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        $model = new $modelName();
        $query = $model::query()
            ->select($valueField . ' as value', $labelField . ' as label')
            ->whereNotNull($valueField)
            ->groupBy($valueField);
        if ($valueField == $labelField) {
            $query = $query->orderByDesc($labelField);
        }
        $records = $query->get();
        $array = [];
        foreach ($records as $record) {
            $subarray['text'] = $record->label;
            $subarray['value'] = $record->value;
            $array[] = $subarray;
        }
        if ($request->input('optionAll')) {
            $array[] = ['value' => null, 'text' => $request->input('optionAllLabel')];
        }
        $result['items'] = $array;
        $result['default'] = $array[0]['value'];

        return $result;
    }
}
