<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <title>{{$list_name}}</title>
    <style>
        table {
            page-break-inside: auto;
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
    </style>
</head>
<body>
<div class="flex text-white py-2 px-2" style="background-color: {{$background_color}}">
    <div>
        <img src="{{$logo_path}}" alt="logo" class="h-6 w-6">
    </div>
    <div class="pl-2">
        {{$list_name}}
    </div>
</div>
<table class="border border-gray-400 text-xs">
    <thead>
        <tr>
            @foreach($headers as $header)
                <th class="border border-gray-400 px-2 py-1 text-left">{{$header}}</th>
            @endforeach
        </tr>
    </thead>
    <tbody>
        @foreach($records as $row)
            <tr class="border border-gray-400">
                @foreach($row as $cell)
                    <td class="border border-gray-400 px-2 py-1">{!! $cell !!}</td>
                @endforeach
            </tr>
        @endforeach
    </tbody>
</table>
<script>
    // enter print mode on load
    //if dev mode local
    @if(config('app.env') !== 'local')
    setTimeout(function () {
        window.print();
    }, 10);
    window.onfocus = function () {
        setTimeout(function () {
            window.close();
        }, 10);
    }
    @endif
</script>
</body>
</html>
