<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use Illuminate\Support\Facades\Http;

class HomeController
{
    public function show()
    {
        try {
            $url = 'https://version.pianola.io';
            $request = Http::get($url);
            $officialVersion = $request->body();
        } catch (\Throwable $th) {
            $officialVersion = null;
        }
        $version = env('PIANOLA_JS_APP_VERSION') ?? $officialVersion ?? 'main';
        $cdnBaseUrl = 'https://cdn.jsdelivr.net/gh/ballet-mecanique/pianola-frontend@';
        $cdnUrl = $cdnBaseUrl.$version;

        return view('pianola-laravel::home', compact('cdnUrl'));
    }
}
